-- Sum the records that have been multipled by the thermostat weights.
--  Time Estimate: up to 1400 seconds
DROP TABLE IF EXISTS sim_hourly_wb_wtd;

CREATE TABLE sim_hourly_wb_wtd(
  TechID TEXT NOT NULL,
  SizingID TEXT NOT NULL,
  BldgType TEXT NOT NULL,
  BldgVint TEXT NOT NULL,
  BldgLoc TEXT NOT NULL,
  BldgHVAC TEXT NOT NULL,
  daynum INT NOT NULL,
  hr01 REAL,
  hr02 REAL,
  hr03 REAL,
  hr04 REAL,
  hr05 REAL,
  hr06 REAL,
  hr07 REAL,
  hr08 REAL,
  hr09 REAL,
  hr10 REAL,
  hr11 REAL,
  hr12 REAL,
  hr13 REAL,
  hr14 REAL,
  hr15 REAL,
  hr16 REAL,
  hr17 REAL,
  hr18 REAL,
  hr19 REAL,
  hr20 REAL,
  hr21 REAL,
  hr22 REAL,
  hr23 REAL,
  hr24 REAL,
  PRIMARY KEY ("TechID", "SizingID", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC",daynum)
);

INSERT INTO sim_hourly_wb_wtd
SELECT
"TechID",
"SizingID",
sim_hourly_wb_twtd."BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC",
daynum,
(sum(hr01)/numbldgs) as hr01,
(sum(hr02)/numbldgs) as hr02,
(sum(hr03)/numbldgs) as hr03,
(sum(hr04)/numbldgs) as hr04,
(sum(hr05)/numbldgs) as hr05,
(sum(hr06)/numbldgs) as hr06,
(sum(hr07)/numbldgs) as hr07,
(sum(hr08)/numbldgs) as hr08,
(sum(hr09)/numbldgs) as hr09,
(sum(hr10)/numbldgs) as hr10,
(sum(hr11)/numbldgs) as hr11,
(sum(hr12)/numbldgs) as hr12,
(sum(hr13)/numbldgs) as hr13,
(sum(hr14)/numbldgs) as hr14,
(sum(hr15)/numbldgs) as hr15,
(sum(hr16)/numbldgs) as hr16,
(sum(hr17)/numbldgs) as hr17,
(sum(hr18)/numbldgs) as hr18,
(sum(hr19)/numbldgs) as hr19,
(sum(hr20)/numbldgs) as hr20,
(sum(hr21)/numbldgs) as hr21,
(sum(hr22)/numbldgs) as hr22,
(sum(hr23)/numbldgs) as hr23,
(sum(hr24)/numbldgs) as hr24
from sim_hourly_wb_twtd
JOIN "NumBldgs" on "NumBldgs"."bldgtype" = sim_hourly_wb_twtd."BldgType"
GROUP BY  
"TechID",
"SizingID",
sim_hourly_wb_twtd."BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC",
 daynum,
 numbldgs
ORDER BY
"TechID",
"SizingID",
sim_hourly_wb_twtd."BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC",
 daynum;

-- Add primary key to table:
--ALTER TABLE "sim_hourly_wb_wtd"
--ALTER COLUMN "TechID" SET NOT NULL,
--ALTER COLUMN "SizingID" SET NOT NULL,
--ALTER COLUMN "BldgType" SET NOT NULL,
--ALTER COLUMN "BldgVint" SET NOT NULL,
--ALTER COLUMN "BldgLoc" SET NOT NULL,
--ALTER COLUMN "BldgHVAC" SET NOT NULL,
--ALTER COLUMN daynum SET NOT NULL,
--ADD PRIMARY KEY ("TechID", "SizingID", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC",daynum);
